# [Volt Dashboard Laravel](https://volt-laravel-admin-dashboard.updivision.com/dashboard) [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/intent/tweet?text=Check%20Volt%20Dashboard%20made%20by%20%40Themesberg%20and%20%40UPDIVISION%20%23webdesign%20%23dashboard%20%23laravel%20%23livewire%20%23bootstrap5&amp;url=https%3A%2F%2Fwww.themesberg.com%2Fproduct%2Flaravel%2Fvolt-pro-admin-dashboard-template)
## Free Frontend Web App for Laravel with Livewire & Alpine.js

[![version](https://img.shields.io/npm/v/@themesberg/volt-bootstrap-5-dashboard)](https://www.npmjs.com/package/@themesberg/volt-laravel-admin-dashboard)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE.md)
[![GitHub issues open](https://img.shields.io/github/issues/themesberg/volt-laravel-admin-dashboard.svg)](https://github.com/themesberg/volt-laravel-admin-dashboard/issues?q=is%3Aopen+is%3Aissue)
[![GitHub issues closed](https://img.shields.io/github/issues-closed-raw/themesberg/volt-laravel-admin-dashboard.svg)](https://github.com/themesberg/volt-laravel-admin-dashboard/issues?q=is%3Aissue+is%3Aclosed)

[![Volt Laravel Dashboard Preview](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/volt-free-laravel-dashboard.jpg)](https://volt-laravel-admin-dashboard.updivision.com/dashboard)

Never start a development project from scratch again. We've partnered with UPDIVISION to create the ultimate design & development toolbox, free for personal and commercial projects. 

Volt Dashboard Laravel features dozens of handcrafted UI elements tailored for Bootstrap 5 and an out of the box Laravel backend. The Livewire integration allows you to build dynamic interfaces easier without leaving the comfort of your favourite framework. If you combine this even further with Alpine.js, you get the perfect combo for your next big project.    

## Ok, I`m in. So, what am I getting?

You're getting a lean, mean, app-building machine made of:  


- 100+ handcrafted UI components tailored for Bootstrap 5 with Vanilla JS. This means buttons, alerts, modals, datepickers and everything in between
- 11 example pages to get you started 
- 3 lightweight plugins: datepicker, notification and charts library
- Sass files & Gulp commands
- fully-functional authentication system, register and user profile editing features built with Laravel
- Livewire & Alpine.js integration


## Free for personal and commercial projects

Whether you're working on a side project or delivering to a client, with Volt Dashboard Laravel you can do both. Volt Dashboard Laravel is released under MIT license, so you can use it for personal and commercial projects for free. Just start coding.    


## Detailed documentation & Gulp commands for an easy workflow


We also included detailed documentation for every component and feature so it helps in your development workflow. Plus you will get an advanced development workflow package including Sass files and a Gulp commands file.


## Table of Contents

* [Versions](#versions)
* [Demo](#demo)
* [Installation](#installation)
* [Documentation](#documentation)
* [File Structure](#file-structure)
* [Browser Support](#browser-support)
* [Resources](#resources)
* [Upgrade to PRO](#upgrade-to-pro)
* [Reporting Issues](#reporting-issues)
* [Technical Support or Questions](#technical-support-or-questions)
* [Licensing](#licensing)
* [Useful Links](#useful-links)

## Versions

[<img src="https://github.com/creativetimofficial/public-assets/blob/master/logos/html-logo.jpg?raw=true" width="60" height="60" />](https://themesberg.com/product/admin-dashboard/volt-bootstrap-5-dashboard)[<img src="https://github.com/creativetimofficial/public-assets/blob/master/logos/react-logo.jpg?raw=true" width="60" height="60" />](https://themesberg.com/product/dashboard/volt-react)[<img src="https://themesberg.s3.us-east-2.amazonaws.com/public/github/technology/laravel-logo.jpeg" width="60" height="60" />](https://themesberg.com/product/laravel/volt-admin-dashboard-template).

| HTML | React  | Laravel  |
| --- | ---  | --- |
| [![Volt Bootstrap 5 Dashboard HTML](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-bootstrap-5-dashboard/volt-bootstrap-5-dashboard-preview.jpg)](https://themesberg.com/product/admin-dashboard/volt-bootstrap-5-dashboard) | [![Volt React Dashboard](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-react-dashboard/thumbnail.png)](https://themesberg.com/product/dashboard/volt-react) | [![Volt Laravel Dashboard](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/volt-free-laravel-dashboard.jpg)](https://themesberg.com/product/laravel/volt-admin-dashboard-template)

## Laravel

| Sign in | Sign up | Profile | Reset password |
| --- | --- | --- | --- |
| [![Sign in](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/sign-in.png)](https://volt-laravel-admin-dashboard.updivision.com/login) | [![Sign up](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/sign-up.png)](https://volt-laravel-admin-dashboard.updivision.com/register) | [<img src = "https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/profile.png" width="87% height = 100%"> ](https://volt-laravel-admin-dashboard.updivision.com/profile) | [![Reset password](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/reset-password.png)](https://volt-laravel-admin-dashboard.updivision.com/forgot-password)

## Demo

| Dashboard | Transactions | Profile | Forms |
| --- | --- | --- | --- |
| [![Dashboard](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/dashboard.png)](https://volt-laravel-admin-dashboard.updivision.com/dashboard) | [![Transactions](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/transactions.png)](https://volt-laravel-admin-dashboard.updivision.com/transactions) | [![Profile](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/profile.png)](https://volt-laravel-admin-dashboard.updivision.com/profile) | [![Forms](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/forms.png)](https://volt-laravel-admin-dashboard.updivision.com/forms)

| Sign in | Sign up | Forgot password | Reset password |
| --- | --- | --- | --- |
| [![Sign in](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/sign-in.png)](https://volt-laravel-admin-dashboard.updivision.com/login) | [![Sign up](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/sign-up.png)](https://volt-laravel-admin-dashboard.updivision.com/register) | [![Forgot Password](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/forgot-password.png)](https://volt-laravel-admin-dashboard.updivision.com/forgot-password) | [![Reset password](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/reset-password.png)](https://volt-laravel-admin-dashboard.updivision.com/forgot-password)

| Lock Profile | 404 Not Found | 500 Server Error | Documentation |
| --- | --- | --- | --- |
| [![Lock Profile](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/lock.png)](https://volt-laravel-admin-dashboard.updivision.com/lock) | [![404 Not Found](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/400.png)](https://volt-laravel-admin-dashboard.updivision.com/404) | [![500 Server Error](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/500.png)](https://volt-laravel-admin-dashboard.updivision.com/500) | [<img src = "https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/github/documentation.png" width = "85%">](https://volt-laravel-admin-dashboard.updivision.com/documentation/getting-started/overview/index.html)

-   [Live Preview](https://volt-laravel-admin-dashboard.updivision.com/dashboard)
-   [Details](https://themesberg.com/product/laravel/volt-admin-dashboard-template)

# Installation

## Prerequisites

If you don't already have an Apache local environment with PHP and MySQL, use one of the following links:

 - Windows: https://updivision.com/blog/post/beginner-s-guide-to-setting-up-your-local-development-environment-on-windows
 - Linux: https://howtoubuntu.org/how-to-install-lamp-on-ubuntu
 - Mac: https://wpshout.com/quick-guides/how-to-install-mamp-on-your-mac/

Also, you will need to install Composer: https://getcomposer.org/doc/00-intro.md

## Laravel
1. Download the project’s zip then copy and paste volt-dashboard-master folder in your projects folder. Rename the folder to your project’s name
2. Make sure you have Node and Composer locally installed.
3.Run the following command in order to download all the project dependencies. `composer install`
4. In your terminal run `npm install`
5. Copy `.env.example` to `.env` and updated the configurations (mainly the database configuration)
6. In your terminal run `php artisan key:generate`
7. Run `php artisan migrate --seed` to create the database tables and seed the roles and users tables
8. Run `php artisan storage:link` to create the storage symlink (if you are using **Vagrant** with **Homestead** for development, remember to ssh into your virtual machine and run the command from there).


## Usage

Register a user or login using admin@volt.com and secret and start testing the Laravel app (make sure to run the migrations and seeders for these credentials to be available).
Make sure to run the migrations and seeders for the above credentials to be available.

Make sure to run the migrations and seeders for the above credentials to be available.

Besides the dashboard and the auth pages this application also has an edit profile page. All the necessary files (controllers, requests, views) are installed out of the box and all the needed routes are added to `routes/web.php`. Keep in mind that all of the features can be viewed once you login using the credentials provided above or by registering your own user.

### Dashboard

You can access the dashboard either by using the "**Dashboard**" link in the left sidebar or by adding **/dashboard** in the URL.


### Sign in

You have the option to log in using the email and password. To access this page, just click the "**Page examples/ Sign in**" link in the left sidebar or add **/login** in the URL.

The `app/Http/Livewire/Auth/Login.php` handles the log in process and validation.

```
   protected $rules = [
        'email' => 'required|email',
        'password' => 'required',
    ];

    public function login()
    {
        $credentials = $this->validate();
        return auth()->attempt($credentials)
                ? redirect()->intended('/profile')
                : $this->addError('email', trans('auth.failed'));
    }
```

### Sign up

You have the option to register an user using the email and password. To access this page, just click the "**Page examples/ Sign up**" link in the left sidebar or add **/register** in the URL.

The `app/Http/Livewire/Auth/Register.php` handles the register process and validation.

```
    public function register()
    {
        $this->validate([
            'email' => 'required',
            'password' => 'required|same:passwordConfirmation|min:6',
        ]);

        $user = User::create([
            'email' =>$this->email,
            'password' => Hash::make($this->password),
            'remember_token' => Str::random(10),
        ]);

        auth()->login($user);

        return redirect('/profile');
    }
```
### Forgot password

You have the option to send an email containing the password reset link to an user. To access this page, just click the "**Page examples/ Forgot password**" link in the left sidebar or add **/forgot-password** in the URL.

The `app/Http/Livewire/ForgotPassword.php` handles the email submission process.

```
    public function recoverPassword() {
        $this->validate();
        $user=User::where('email', $this->email)->first();
        $this->notify(new ResetPassword($user->id));
        $this->mailSentAlert = true;
        }
    }
```

The `app/Notifications/ResetPassword.php` handles the email submission itself. Here you can edit the overall layout of the email.
```
    public function toMail($notifiable)
    {
        $url = URL::signedRoute('reset-password', ['id' => $this->token]);
        return (new MailMessage)
                    ->subject('Reset your password')
                    ->line('Hey, did you forget your password? Click the button to reset it.')
                    ->action('Reset Password', $url)
                    ->line('Thank you for using our application!');
    }

```

### Reset password

The email sent through the forgot password process will send the user to an unique link containing the password reset form. To access an example of this page, just click the "**Page examples/ Reset password**" link in the left sidebar or add **/reset-password-example** in the URL.

The `app/Http/Livewire/ResetPassword.php` handles the password reset process and validation.

```

    public function resetPassword() {
        $this->validate();
        $existingUser = User::where('email', $this->email)->first();
        if($existingUser && $existingUser->id == $this->urlId) {
            $existingUser->update([
                'password' => Hash::make($this->password)
            ]);
            $this->isPasswordChanged = true;
            $this->wrongEmail = false;
        }
        else {
            $this->wrongEmail = true;
        }
    }
    
```

### User Profile

You have the option to edit the current logged in user's profile information (name, email, profile picture) and password. To access this page, just click the "**Profile**" link in the left sidebar or add **/profile** in the URL.

The `app/Http/Livewire/Profile.php` handles the update of the user information and password.

```
    public function mount() { $this->user = auth()->user(); }

    public function save()
    {
        $this->validate();

        $this->user->save();

        $this->showSavedAlert = true;
            
        }
    }
```

If you input the wrong data when editing the profile, don't worry. Validation rules have been added to prevent this.

```
    protected $rules = [
        'user.first_name' => 'max:15',
        'user.last_name' => 'max:20',
        'user.birthday' => 'date_format:Y-m-d',
        'user.email' => 'email',
        'user.phone' => 'numeric',
        'user.gender' => '',
        'user.address' => 'max:20',
        'user.number' => 'numeric',
        'user.city' => 'max:20',
        'user.zip' => 'numeric',
    ];

```


## Documentation
The documentation for Volt is hosted on our [website](https://volt-laravel-admin-dashboard.updivision.com/documentation/getting-started/overview/index.html).

## File Structure
Within the download you'll find the following directories and files:

```

├── components
│   ├── buttons.blade.php                       # Buttons page
│   ├── forms.blade.php                         # Forms page
│   ├── modals.blade.php                        # Modals page
│   ├── notifications.blade.php                 # Notifications page
│   └── typography.blade.php                    # Typography page
├── dashboard.blade.php                         # Dashboard
├── layouts
│   ├── app.blade.php                           # Including layouts based on routes
│   ├── base.blade.php                          # All the styles and scripts included
│   ├── footer2.blade.php                       # Footer for pages without sidenav
│   ├── footer.blade.php                        # Footer for pages with sidenav
│   ├── nav.blade.php                           # Nav for mobile view 
│   ├── sidenav.blade.php                       # The sidebar menu
│   └── topbar.blade.php                        # Search bar, notifications and user area
├── livewire                                    # All the pages that are using livewire functionality
│   ├── auth                                    # Handles auth routes (login and register)
│   │   ├── login.blade.php                     
│   │   └── register.blade.php
│   ├── forgot-password.blade.php               # Handles the forgot-password form
│   ├── logout.blade.php                        # Logout functionality
│   ├── profile.blade.php                       # Profile page
│   ├── reset-password.blade.php                # Handles the reset password form
│   └── users.blade.php                         # Users table
├── upgrade-to-pro.blade.php                    # Upgrade to pro page
├── lock.blade.php                              # Lock page
└── transactions.blade.php                      # Transactions page
├── 404.blade.php                               # Error 404 page
├── 500.blade.php                               # Error 500 page
├── bootstrap-tables.blade.php                  # Bootstrap tables page                
```

## Browser Support

At present, we officially aim to support the last two versions of the following browsers:

<img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/chrome.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/firefox.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/edge.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/safari.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/opera.png" width="64" height="64">

## Resources
- Demo: <https://volt-laravel-admin-dashboard.updivision.com/dashboard>
- Download Page: <https://themesberg.com/product/laravel/volt-admin-dashboard-template>
- Documentation: <https://volt-laravel-admin-dashboard.updivision.com/documentation/getting-started/overview/index.html>
- License Agreement: <https://themesberg.com/licensing>
- Support: <https://themesberg.com/contact>
- Issues: [Github Issues Page](https://github.com/themesberg/volt-laravel-admin-dashboard/issues)
- **Dashboards:**

| HTML | React  | Laravel  |
| --- | ---  | --- |
| [![Volt Bootstrap 5 Dashboard HTML](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-bootstrap-5-dashboard/volt-bootstrap-5-dashboard-preview.jpg)](https://volt-laravel-admin-dashboard.updivision.com/dashboard) | [![Volt React Dashboard](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-react-dashboard/thumbnail.png)](https://github.com/themesberg/volt-react-dashboard) | [![Volt React Dashboard](https://themesberg.s3.us-east-2.amazonaws.com/public/products/volt-laravel-dashboard/volt-free-laravel-dashboard.jpg)](https://github.com/themesberg/volt-laravel-admin-dashboard)

## Change log

Please see the [changelog](CHANGELOG.md) for more information on what has changed recently.


## Upgrade to Pro

Take front-end development to the next level by upgrading to the PRO version of Volt Laravel Admin Dashboard featuring over 3 times more components, plugin and pages and 5 times more Laravel features. You also get 6 months of premium support and free updates. Check out [Volt Pro Premium Laravel Admin Dashboard](https://themesberg.com/product/laravel/volt-pro-admin-dashboard-template).

## Reporting Issues

We use GitHub Issues as the official bug tracker for Volt Laravel Admin Dashboard. Here are some advices for our users that want to report an issue:

1. Make sure that you are using the latest version of Volt Laravel Admin Dashboard. Check the CHANGELOG from your dashboard on our [website](https://themesberg.com/docs/volt-laravel-admin-dashboard/getting-started/changelog/).
2. Providing us reproducible steps for the issue will shorten the time it takes for it to be fixed.
3. Some issues may be browser specific, so specifying in what browser you encountered the issue might help.

## Technical Support or Questions

If you have questions or need help integrating the product please [contact us](https://themesberg.com/contact) instead of opening an issue.

## Licensing

- Copyright 2021 Themesberg (Crafty Dwarf LLC) (https://themesberg.com)
- Themesberg [license](https://themesberg.com/licensing#mit) (MIT License)

## Useful Links

- [More themes](https://themesberg.com/themes) from Themesberg
- [Free themes](https://themesberg.com/templates/free) from Themesberg
- [Bootstrap Themes, Templates & UI Kits](https://themesberg.com/templates/laravel/) from Themesberg
- [Affiliate Program](https://themesberg.com/affiliate)

## Social Media

### Themesberg

Twitter: <https://twitter.com/themesberg>

Facebook: <https://www.facebook.com/themesberg/>

Dribbble: <https://dribbble.com/themesberg>

Instagram: <https://www.instagram.com/themesberg/>

### Updivision:

Twitter: <https://twitter.com/updivision?ref=pdl-readme>

Facebook: <https://www.facebook.com/updivision?ref=pdl-readme>

Linkedin: <https://www.linkedin.com/company/updivision?ref=pdl-readme>

Updivision Blog: <https://updivision.com/blog/?ref=pdl-readme>

## Credits

- [Themesberg](https://themesberg.com/)
- [UPDIVISION](https://updivision.com)
