<?php 
include "functions.php";
use SAPb1\Filters\Equal;
use SAPb1\Filters\InArray;

try 
{
    session_start();
    $DocEntry = $_GET["DocEntry"];
    $sap = Login();
   
    if( $DocEntry == "") {

        //CONSULTATION
        $ConsultationsLines_result = $sap->getService("view.svc/B1_LINESB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_Consultation,U_Description,U_Notes')->orderBy("DocEntry", "desc")->limit(1)->findAll();
        //ORDONNANCE
        $OrdonnanceLines_result = $sap->getService("view.svc/B1_ORDONNANCEB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Qte,U_Instructions')->orderBy("DocEntry", "desc")->limit(1)->findAll();
        //RADIO
        $RadioLines_result = $sap->getService("view.svc/B1_RADIOB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Instructions')->orderBy("DocEntry", "desc")->limit(1)->findAll();
        //ANALYSE
        $AnalyseLines_result = $sap->getService("view.svc/B1_ANALYSEB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Instructions')->orderBy("DocEntry", "desc")->limit(1)->findAll();

    }else {

        //CONSULTATION
        $ConsultationsLines_result = $sap->getService("view.svc/B1_LINESB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_Consultation,U_Description,U_Notes')->where(new Equal("DocEntry", intval($DocEntry) ))->findAll();
        //ORDONNANCE
        $OrdonnanceLines_result = $sap->getService("view.svc/B1_ORDONNANCEB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Qte,U_Instructions')->where(new Equal("DocEntry", intval($DocEntry) ))->findAll();
        //RADIO
        $RadioLines_result = $sap->getService("view.svc/B1_RADIOB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Instructions')->where(new Equal("DocEntry", intval($DocEntry) ))->findAll();
        //ANALYSE
        $AnalyseLines_result = $sap->getService("view.svc/B1_ANALYSEB1SLQuery")->queryBuilder()
        ->select('DocEntry,U_ItemCode,U_Description,U_Instructions')->where(new Equal("DocEntry", intval($DocEntry) ))->findAll();
    
    }
    
        $ConsultationsLines = json_decode(json_encode($ConsultationsLines_result), TRUE);
        $OrdonnanceLines = json_decode(json_encode($OrdonnanceLines_result), TRUE);
        $RadioLines = json_decode(json_encode($RadioLines_result), TRUE);
        $AnalyseLines = json_decode(json_encode($AnalyseLines_result), TRUE);
        
        echo json_encode([$ConsultationsLines['value'], $OrdonnanceLines['value'], $RadioLines['value'], $AnalyseLines['value']]);


} catch (Exception $e) {
    echo $e->getMessage();    
}