<?php 
include "functions.php";
use SAPb1\Filters\Equal;
use SAPb1\Filters\InArray;

try 
{
    session_start();
    $DocEntry = $_GET["DocEntry"];
    $sap = Login();

    if( $DocEntry == "") {
 
        $ConsultationsList = $sap->getService("view.svc/B1_CONSULTATIONMCB1SLQuery");
        $Consultations_result = $ConsultationsList->queryBuilder()
        ->select('DocEntry,CodePatient,NomPatient,U_DateConsultation,U_Notes,U_ActivityType,U_Statut,U_Poids,U_PA')
        ->orderBy("DocEntry", "desc")
        ->limit(1)
        ->findAll();

    } else {
        $ConsultationsList = $sap->getService("view.svc/B1_CONSULTATIONMCB1SLQuery");
        $Consultations_result = $ConsultationsList->queryBuilder()
        ->select('DocEntry,CodePatient,NomPatient,U_DateConsultation,U_Notes,U_ActivityType,U_Statut,U_Poids,U_PA')
        ->where(new Equal("DocEntry", intval($DocEntry) ))
        ->findAll(); 
    
    }
    
    $Consultations = json_decode(json_encode($Consultations_result), TRUE);
    echo json_encode($Consultations['value']);


} catch (Exception $e) {
    echo $e->getMessage();    
}