<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login </title>
    <link rel="stylesheet" href="assets/css/main/app.css">
    <link rel="stylesheet" href="assets/css/pages/auth.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="shortcut icon" href="assets/images/logo/favicon.svg" type="image/x-icon">
    <link rel="shortcut icon" href="assets/images/logo/favicon.png" type="image/png">
    <style>
        body{
            background-color: #ebf0fd;
        }
        .container{
            display: flex;
            justify-content: center;
            padding-top: 50px;
        }
        .input{
            display: block;
            padding: 0 20px;
        }
        .box{
            width: 250px;
            min-height: 400px;
            background-color: #fefcff;
            border-radius: 20px;
            position: relative;
        }
        .img{
            padding-top: 10px;
            display: flex;
            justify-content: center;
           
        }
        .img i{
            font-size: 5rem;
            color: #1e1366;
        }
        .title h3{
            text-align: center;
            padding: 10px 0;
            color: #1e1366;
        }
        .Inputs{
            padding: 2px 0;
        }
        .Inputs label{
            color:  #423b76;
            font-weight: bold;
            position: relative;
        }
        .Inputs input{
            outline: none;
            /* transition: .5s; */
            border-radius: 5px;
            border: 1px solid #423b76;
            position: relative;
            padding: 0 3px;
        }
        input:focus {
			border: 2px solid #423b76;
		}
        .button{
            display: flex;
            justify-content: center;
            padding-top: 15px;
            position: relative;
        }
        .button button{
            cursor: pointer;
            outline: none;
            width: 85%;
            border-radius: 5px;
            border: solid 2px #1e1366;
            transition: .5s;
            font-weight: bold;
            background-color: #ebf0fd;
        }
        .button button:hover{
            background-color: #1e1366;
            color: #ebf0fd;
        }
        .Inputs i{
            position: absolute;
            right: 40px;
            font-size: 20px;
            padding-top: 3px;
            color: #423b76;
        }
    </style>
</head>
<body>
    <form action="ServiceLayer/CheckLogin.php" class="form" id="loginform"  method="post" data-parsley-validate>
        <section class="section">
            <div class="container">
                <div class="box">
                    <div class="img">
                        <i class="fa-solid fa-user"></i>
                    </div>
                    <div class="title">
                        <h3>Login</h3>
                    </div>
                    <div class="input">
                        <div class="Inputs"><label for="FirstName">Prenom</label></div>
                        <div class="Inputs"><input type="text" id="FirstName" name="FirstName" class="inputText" required></div>
                        <div class="Inputs"><label for="LastName">Nom</label></div>
                        <div class="Inputs"><input type="text" id="LastName" name="LastName" class="inputText" required></div>
                        <div class="Inputs"><label for="PWD">Password</label></div>
                        <div class="Inputs"><input type="password" id="PWD" name="PWD" class="inputText" required></div>    
                    </div>
                    <div class="button">
                        <button name="login">Login</button>
                    </div>
                    <div class="error">
                        <?php  if (isset($_SESSION["errorMessage"])) { ?>
                            <div class="alert alert-danger alert-dismissible show fade" style="margin:5px 10px; width:90%;">
                            <?php  echo $_SESSION["errorMessage"]; ?>.
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php unset($_SESSION["errorMessage"]); } ?>
                    </div>
                </div>
            </div>
        </section>
    </form>>    
</body>
<script src="assets/js/bootstrap.js"></script>
<script src="assets/js/app.js"></script>

<script src="assets/extensions/jquery/jquery.min.js"></script>
<script src="assets/extensions/parsleyjs/parsley.min.js"></script>
<script src="assets/js/pages/parsley.js"></script>
</html>