<?php
    if (session_status() === PHP_SESSION_NONE) {
        session_start();    
    }

    if (! empty($_SESSION['FirstName']))
    {}
    else
    {
        header('location:login.php'); 
    }
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Table Datatable Jquery - Mazer Admin Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/main/app.css">
    <link rel="stylesheet" href="assets/css/main/app-dark.css">
    <link rel="shortcut icon" href="assets/images/logo/favicon.svg" type="image/x-icon">
    <link rel="shortcut icon" href="assets/images/logo/favicon.png" type="image/png">
    
<link rel="stylesheet" href="assets/css/pages/fontawesome.css">
<link rel="stylesheet" href="assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="assets/css/pages/datatables.css">
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/index.global.min.js'></script>
</head>

<body>
    <div id="app">
        <div id="sidebar" class="active">
            <div class="sidebar-wrapper active">
    
    <?php include 'parts/sidebar.php';?>


</div>
        </div>
        <div id="main">
            <header class="mb-3">
                <a href="#" class="burger-btn d-block d-xl-none">
                    <i class="bi bi-justify fs-3"></i>
                </a>
            </header>
            
<div class="page-heading">
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-8 order-md-1 order-last">
                <h3>Liste des Consultations En attente</h3>
                <p class="text-subtitle text-muted">Powerful interactive tables with datatables (jQuery required)</p>
            </div>
            <div class="col-12 col-md-4 order-md-2 order-first">                     
                          <div class="card">
                             <div class="card-body py-4 px-4">
                                 <div class="d-flex align-items-center">
                                     <div class="avatar avatar-xl">
                                         <img src="assets/images/faces/avatar.jpg" alt="Face 1">
                                     </div>
                                     <div class="ms-3 name">
                                         <h5 class="font-bold"> Dr.                                                                            
                                               <?php if (isset($_SESSION["FirstName"])) { ?> 
                                                    <?php  echo $_SESSION["FirstName"]; ?> <?php  echo $_SESSION["LastName"];  ?>
                                               <?php } else {
                                                	header("location:login.php"); 
                                             } ?>
                                         </h5>
                                     </div>
                                     <div class="ms-3 name">
                                            <ol class="breadcrumb">
                                                  <i id="openModal" class="bi bi-calendar2-range-fill" style="font-size: 120%; color: #435ebe"></i>                                                     
                                             </ol>
                                     </div>
                                     <div class="ms-3 name">
                                            <article style="margin-top: 55%; font-size: 120%; color: #435ebe" id="sign-out-alt" class="icon col-6 col-md-3 col-lg-2 pr4 pb2 pt2 bb bw1 b--gray1 hover-black bw0-pr db fl-pr">
                                                <dl class="dt w-100 ma0 pa0">
                                                    <dt class="the-icon"> 
                                                        <a style="margin-top: 55%; font-size: 120%; color: #435ebe"  href="ServiceLayer/Logout.php" class="fa-fw select-all fas"></a>
                                                    </dt>
                                                </dl>
                                            </article>
                                     </div>
                                     
                                            
                                 </div>
                             </div>
                         </div> 
              </div>

              
            
        </div>
    </div>
    
    <!-- Basic Tables start -->
    <section class="section">
        <div class="card">
                <section id="custom-checkbox-colored a">
                    <div class="row ">
                        <div class="col-12">
                            <div class="card"> 
                                <div class="card-content ">
                                    <div class="card-body ">
                                        
                                        <ul class="list-unstyled mb-0 "style="float:right"> 

                                            <li class="d-inline-block me-2 mb-1 ">
                                                <div class="form-check ">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="radio" name="status[]" class="form-check-input form-check-success" value="Planifiée"  id="customColorCheck3">
                                                        <label class="form-check-label"  for="customColorCheck3" >Planifiée</label>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="d-inline-block me-2 mb-1">
                                                <div class="form-check">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="radio" name="status[]" class="form-check-input form-check-danger" value="En attente"   id="customColorCheck4">
                                                        <label class="form-check-label" for="customColorCheck4">En attente</label>
                                                    </div>
                                                </div>
                                            </li>
                                            
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            
                <div class="card-body">
                <table class="table" id="table1">
                    <thead>
                        <tr>
                            <th>N° Consultation</th>
                            <th>Nom Patient</th>
                            <th>Type de consultation</th>
                            <th>Date Consultation</th>
                            <th>Note</th>
                            <th>Statut</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
         
                </table>
            </div> 
        </div>      
    </section>
    <!-- Basic Tables end -->
            
    </div> 
        </div>

        <!-- Modal -->
        <div class="modal top fade" id="myModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="true" data-bs-keyboard="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Calendrier des consultations</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                        <div id="calendar" class="modal-body">
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/app.js"></script>
    
<script src="assets/extensions/jquery/jquery.min.js"></script>
<script src="https://cdn.datatables.net/v/bs5/dt-1.12.1/datatables.min.js"></script>
<script src="assets/js/pages/datatables.js"></script>

<script>

        var table = $('#table1').DataTable();
        LoadTable();

        $('#openModal').click(function() {
            $('#myModal').modal('show');
        });
        $('#myModal').on('shown.bs.modal', function () {
            LoadCalendar();
        });

        $(document).ready(function() {

                $("#Consultation").removeClass("active");
                $("#Dashboard").addClass("active");

                $('input[type="radio"][name="status[]"]').change(function() {
                    var checkedStatuses = [];
                    $('input[type="radio"][name="status[]"]:checked').each(function() {
                        checkedStatuses.push($(this).val());
                    });
                    if (checkedStatuses.length === 0) {
                        table.column(5).search('').draw();
                    } else if (checkedStatuses.length === 1) {
                        table.column(5).search('^' + checkedStatuses[0] + '$', true, false).draw();
                    }
                }); 
            
        });


        function getDateToday()
        {
            const today = new Date();
            const dd = String(today.getDate()).padStart(2, '0');
            const mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
            const yyyy = today.getFullYear();

            return [mm, dd, yyyy];
        }
        
        const [mm, dd, yyyy] = getDateToday();
            var sources = {
                 sourceone: {
                    type: "GET",
                    url: "ServiceLayer/GetSchedule.php",    
                    cache: false,       //this is optional
                    color: '#435ebe',   //this is optional
                    textColor: 'white'  //this is optional
                }
        }

        function LoadTable() {

            table.destroy();
            table = $('#table1').DataTable(
            {   

            ajax: {
                    url: 'ServiceLayer/GetListConsultation.php',
                    dataSrc: ""
            },"initComplete": function(settings, json) {
                    $("#customColorCheck4").click();

                },
            "autoWidth": false,
            "lengthChange": false,
            "info": false,          
            "language": { 
                "zeroRecords": "",
                search: '',
                searchPlaceholder: 'Recherche',
                "emptyTable": "",
                "paginate": {
                "next":       '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-caret-right-fill" viewBox="0 0 16 16"><path d="m12.14 8.753-5.482 4.796c-.646.566-1.658.106-1.658-.753V3.204a1 1 0 0 1 1.659-.753l5.48 4.796a1 1 0 0 1 0 1.506z"/></svg>',
                "previous":   '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-caret-left-fill" viewBox="0 0 16 16"><path d="m3.86 8.753 5.482 4.796c.646.566 1.658.106 1.658-.753V3.204a1 1 0 0 0-1.659-.753l-5.48 4.796a1 1 0 0 0 0 1.506z"/></svg>'
            }},
                columns: 
                [
                    { data: 'DocEntry' },
                    { data: 'NomPatient' },
                    { data: 'U_ActivityType' },
                    { data: 'U_DateConsultation' },
                    { data: 'U_Notes' },
                    { data: 'U_Statut' },
                    { data: '' }
                    
                ],
                "columnDefs": [ 
                    { "width": "20%", "targets": 4 },
                    {
                        className:"position",targets: [6], 
                        "render": function ( data, type, row ) { return '<a href="Consultation.php?DocEntry='+row.DocEntry+'"> <i class="bi bi-pencil-square" style="color: #435ebe"></i></a>'; }
                    }
            ]

            });


        }

        function LoadCalendar() {

            var calendarEl = document.getElementById('calendar');
            var calendar = new FullCalendar.Calendar(calendarEl, {                
                headerToolbar: {
                    left: 'prevYear,prev,next,nextYear today',
                    center: 'title',
                    right: 'dayGridMonth,dayGridWeek,dayGridDay'
                },
                initialDate: `${yyyy}-${mm}-12`,
                height: 800,
                navLinks: true,
                editable: true,
                dayMaxEvents: true, 
                eventSources: [sources.sourceone],

                eventClick: function(event) {
                    if (event.event.url) {
                        event.jsEvent.preventDefault();
                        window.open(event.event.url, "_blank");
                    }
                }
            });

            calendar.render();

        }



</script>
</body>

</html>
