<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form Layout - Mazer Admin Dashboard</title>

    <link rel="stylesheet" href="assets/css/main/app.css">
    <link rel="stylesheet" href="assets/css/main/app-dark.css">
    <link rel="shortcut icon" href="assets/images/logo/favicon.svg" type="image/x-icon">
    <link rel="shortcut icon" href="assets/images/logo/favicon.png" type="image/png">

    <link rel="stylesheet" href="assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="assets/css/pages/datatables.css">

</head>

<body>
    <div id="app">
        <div id="sidebar" class="active">
            <div class="sidebar-wrapper active">
                
                <?php include 'parts/sidebar.php';?>

            </div>
        </div>
        <div id="main">
            <header class="mb-3">
                <a href="#" class="burger-btn d-block d-xl-none">
                    <i class="bi bi-justify fs-3"></i>
                </a>
            </header>

            <div class="page-heading">
                <div class="page-title">
                    <div class="row">
                        <div class="col-12 col-md-10 order-md-1 order-last">
                            <h3>Consultation</h3>
                        </div>
                        <div class="col-12 col-md-2 order-md-2 order-first">                     
                                 <div class="card-body py-4 px-4">
                             </div> 
                        </div>
                         
                    </div>
                </div>

                <form id="add_name" action="ServiceLayer/CreateConsultation.php" method="post">

                <!-- // Basic multiple Column Form section start -->
                <section id="multiple-column-form">
                    <div class="row match-height">
                        <div class="col-12">
                            <div class="card">
                               
                                <div class="card-content">
                                    <div class="card-body">
                                        
                                            <div class="row">
                                                
                                                <div class="col-md-6 col-12" style="display:none">
                                                    <div class="form-group">
                                                        <label for="DocEntry">Code Patient</label>
                                                        <input type="text" id="DocEntry" class="form-control" name="DocEntry">
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="PCode">Code Patient</label>
                                                        <input type="text" id="PCode" class="form-control" name="Pcode" disabled>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="PName">Nom Patient</label>
                                                        <input type="text" id="PName" class="form-control" name="Pname"  disabled>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="Type">Type de consultation</label>
                                                        <input type="text" id="Type" class="form-control"  name="type"  disabled>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="ConsDate">Date Consultation</label>
                                                        <input type="date" id="ConsDate" class="form-control" name="date"  value="2023-04-18" disabled> 
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="Poids">Poids</label>
                                                        <input type="text" id="Poids" class="form-control" name="Poids" >
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label for="PA">Pression artérielle</label>
                                                        <input type="text" id="PA" class="form-control" name="PA" >
                                                    </div>
                                                </div> 
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group mb-3">
                                                        <label for="Note" class="form-label">Note</label>
                                                        <textarea class="form-control" id="Note" rows="2" name="Notes"></textarea>
                                                    </div>                                                    
                                                </div>   
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group mb-3">
                                                        <label for="Statut" class="form-label">Statut</label>
                                                        <fieldset class="form-group">
                                                            <select class="form-select" id="Statut" name="Statut">
                                                                <option value="Planifiée">Planifiée</option>
                                                                <option value="En attente">En attente</option>
                                                                <option value="Cloturée">Cloturée</option>
                                                            </select>
                                                        </fieldset>
                                                    </div>                                                    
                                                </div>                                           
                                                
                                            </div>

                                            <div style="border-top: 1px solid#457b9d; padding-top:15px; font-size:85%" >  </div> 
                                               <!-- Pills Tabs -->
                                                    <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                                        <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="pills-Consultation-tab" data-bs-toggle="pill" data-bs-target="#pills-Consultation" type="button" role="tab" aria-controls="pills-Consultation" aria-selected="true">Consultation</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                        <button class="nav-link " id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="false">Ordonnance médicale</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">Radiographie</button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact" type="button" role="tab" aria-controls="pills-contact" aria-selected="false">Analyses </button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="pills-Historique-tab" data-bs-toggle="pill" data-bs-target="#pills-Historique" type="button" role="tab" aria-controls="pills-Historique" aria-selected="false">Historique</button>
                                                        </li>
                                                    </ul>
                                     <div class="tab-content pt-2" id="myTabContent">
                                            <!-- Pills Tabs -->   
                                            <!-- Consultation -->
                                               <div class="tab-pane fade show active"  id="pills-Consultation" role="tabpanel" aria-labelledby="Consultation-tab">

                                                    <div class="form-outline"> <label class="form-label" for="typeNumber" ></label> </div>
                                                        <div class="col-md-4"></div>
                                                        <div class="input-group">                                            
                                                            <div class="input-group"> </div>
                                                        </div>
                                                    <div class="col-md-4"></div>

                                                    <div class="input-group mb-3">
                                                        <div class="col-xs-2"> <input readonly type="text" class="form-control mb-3 first-input " id="article_Consultation" name="Consultation[ItemCode][]" placeholder="Consultation ">     </div>                                               
                                                        <div class="col-xs-2"> <button type="button" id= "consultation" class=" btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#staticBackdrop_">+</button> </div> 
                                                        <div class="col-lg-2"> <input type="text" id="article_ConDescription" name="Consultation[ItemName][]" class="form-control mb-3 " placeholder="Description"/> </div> 
                                                        <textarea rows = "1" type="text" id="Notes" name="Consultation[Notes][] " class="form-control mb-3 " placeholder="Notes"></textarea>
                                                     </div>

                                                </div>
                                                <!-- Modal -->
                                                <div class="modal fade" id="staticBackdrop_" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel_" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                                                    <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h1 class="modal-title fs-5" id="staticBackdropLabel_">List</h1>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <!-- table -->
                                                    <table class="table" id="table">
                                                        <thead>
                                                            <tr>
                                                                <th>Code Article</th>
                                                                <th>Nom Article</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                        
                                                    <!-- end table -->
                                                        </div>
                                                        
                                                        </div>
                                                    </div>
                                                    
                                                    </div>
                                                <!-- end Modal -->
 
                                            <!--end  Consultation -->
                                           
                                            <!--  Médicament -->
                                            <div class="tab-pane fade " id="pills-home" role="tabpanel" aria-labelledby="home-tab">
                                                    <button class="add_field_button  ml-auto p-2 mb-4  btn btn-primary" >Ajouter Médicament</button> 

                                                    <div class="form-outline"> <label class="form-label" for="typeNumber" ></label> </div>
                                                    <div class="col-md-4"></div>
                                                    <div class="input-group1"> <div class="input-group"> </div> </div>
                                                    <div class="col-md-4"></div>

                                            </div>
                                            <!-- Modal -->
                                             <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                              <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                                                <div class="modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- table -->
                                                    <table class="table" id="table1">
                                                        <thead>
                                                            <tr>
                                                                <th>Code Article</th>
                                                                <th>Nom Article</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                   </table>
                                    
                                                  <!-- end table -->
                                                    </div>
                                                    
                                                    </div>
                                                </div>
                                                
                                                </div>
                                             <!-- end Modal -->
                                            <!-- end Médicament -->
 
                                            <!--  Radio -->
                                             <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="profile-tab">
                                             <button class="add_field_button2  ml-auto p-2 mb-3  btn btn-primary" >Ajouter Radiographie</button> 

                                                    <div class="form-outline"> <label class="form-label" for="typeNumber" ></label> </div>
                                                    <div class="col-md-4"></div>
                                                    <div class="input-group2"> <div class="input-group"> </div> </div>
                                                    <div class="col-md-4"></div></div>
                                            
                                                <!--  Modal -->
                                                <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                 <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                                                  <div class="modal-content">
                                                  <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                  </div>
                                                  <div class="modal-body">
                                                    <!-- table -->
                                                    <table class="table" id="table2">
                                                            <thead>
                                                                <tr>
                                                                    <th>Code Article</th>
                                                                    <th>Nom Article</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                    </table>
                                    
                                                  <!-- end table -->
                                                    </div>
                                                    
                                                    </div>
                                                </div>
                                                
                                            </div>
                                                <!-- end Modal -->
                                            <!-- end Radio -->
                                    
                                            <!--  Analyse -->
                                                <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="contact-tab">
                                                        <button class="add_field_button3  ml-auto p-2 mb-3  btn btn-primary" >Ajouter Analyse</button> 

                                                        <div class="form-outline"> <label class="form-label" for="typeNumber"></label> </div>
                                                        <div class="col-md-4"></div>
                                                        <div class="input-group3"> <div class="input-group"> </div> </div>
                                                        <div class="col-md-4"></div>
                                                </div>
                                                <!--  Modal -->
                                                <div class="modal fade" id="staticBackdrop2" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                 <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                                                  <div class="modal-content">
                                                  <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                  </div>
                                                  <div class="modal-body">
                                                    <!-- table -->
                                                    <table class="table" id="table3">
                                                        <thead>
                                                                <tr>
                                                                    <th>Code Article</th>
                                                                    <th>Nom Article</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                    </table>
                                    
                                                  <!-- end table -->
                                                    </div>
                                                    
                                                    </div>
                                                </div>
                                                
                                                </div>
                                                <!-- end Modal -->
                                            <!-- End Analyse -->

                                            <!-- Historique -->
                                                <div class="tab-pane fade" id="pills-Historique" role="tabpanel" aria-labelledby="Historique-tab">
                                                            <input type="radio" name="gender" value="all" checked>Tout
                                                            <input type="radio" name="gender" value="one">Mes consultations
                                                            
                                                            <table id="example" class="table table-striped" style="width:100%">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Consultation</th>
                                                                        <th>Ordonnance</th>
                                                                        <th>Radiographie</th>
                                                                        <th>Analyse</th>
                                                                        <th>Date Consultation</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                            </table>
                                                            <!-- end table -->
                                                </div>
                                            <!-- End Historique -->
                                            <button type="submit" name="submit"  class="btn btn-primary mb-3">Submit</button>

                                    </div>
                                    
                                </div>
                                
                            </div>
                            
                        </div>
                        
                    </div>
                    
                </section>
                <!-- // Basic multiple Column Form section end -->
                </form>    
              
            </div>

            <footer>
            
            </footer>
        </div>
    </div>

    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/extensions/jquery/jquery.min.js"></script>
    <script src="https://cdn.datatables.net/v/bs5/dt-1.12.1/datatables.min.js"></script>
    <script src="assets/js/pages/datatables.js"></script>

<script>

    var item = 0;
    var item1 = 0;
    var item2 = 0;

    $(document).ready(function() {
        
        var wrapper   		= $(".input-group1");
        var add_button      = $(".add_field_button");
        var add_more        =$(".add_more");      
        var x = -1; 
        $(add_button).click(function(e){ 
        e.preventDefault();
                x++;         
                $(wrapper).append('<div class="input-group mb-3"> <div class="col-xs-2"><input readonly type="text" class="form-control mb-3 first-input " id="article_'+x+'" name="Medicament[ItemCode][]" placeholder="Médicament "> </div><button type="button" id= '+x+' onclick="add(this)" class=" btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#staticBackdrop">+</button><input type="text" id="Description_'+x+'" name="Medicament[ItemName][]" class="form-control mb-3 " placeholder="Description" /><div class="col-xs-1"><input id="articleQte_'+x+'" type="number" id="typeNumber" value="1" min="1" name="Medicament[Quantity][]" class="form-control mb-3 " placeholder="Quantity" /> </div><input id="articleInstruction_'+x+'" type="text" class="form-control mb-3" name="Medicament[Instruction][]" placeholder="Instructions "> <div class="input-group-append"><button class="btn btn-outline-danger remove_field" type="button"><i class="bi bi-trash"></i></button></div></div>'); //add input box
        });
        $(wrapper).on("click",".remove_field", function(e){ 
            e.preventDefault(); $(this).parent('div').parent('div').remove(); x--;
        })

    });
    
    $(document).ready(function() {

        var wrapper   		= $(".input-group2");
        var add_button2      = $(".add_field_button2");
        var Y = -1;
        $(add_button2).click(function(e){ 
        e.preventDefault();
                Y++;
                $(wrapper).append('<div class="input-group mb-3"><div class="col-xs-2"><input readonly type="text" class="form-control mb-3" id="radio_'+Y+'" name="Radio[ItemCode][]" placeholder="Radiographie "> </div><button type="button" id='+Y+' onclick="add1(this)" class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#staticBackdrop1">+</button><input type="text" id="RadioDescription_'+Y+'" name="Radio[ItemName][]" class="form-control mb-3 " placeholder="Description" /><input id="RadioInstruction_'+Y+'" type="text" class="form-control mb-3" name="Radio[Instruction][]" placeholder="Instructions "> <div class="input-group-append"><button class="btn btn-outline-danger remove_field" type="button"><i class="bi bi-trash"></i></button></div></div>'); //add input box
        });
        $(wrapper).on("click",".remove_field", function(e){ 
            e.preventDefault(); $(this).parent('div').parent('div').remove(); Y--;
        });

    });

    $(document).ready(function() {

            var wrapper = $(".input-group3");
            var add_button3 = $(".add_field_button3");
            var z = -1;
            $(add_button3).click(function(e) {
                e.preventDefault();
                z++;
                $(wrapper).append('<div class="input-group mb-3">  <div class="col-xs-2"><input readonly type="text" class="form-control mb-3 " id="analyse_'+z+'" name="Analyse[ItemCode][]" placeholder="Analyse "> </div><button type="button" id='+z+' onclick="add2(this)" class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#staticBackdrop2">+</button><input type="text" id="AnalyseDescription_'+z+'" name="Analyse[ItemName][]" class="form-control mb-3 " placeholder="Description" /><input id="AnalyseInstruction_'+z+'" type="text" class="form-control mb-3" name="Analyse[Instruction][]" placeholder="Instructions "> <div class="input-group-append"><button class="btn btn-outline-danger remove_field" type="button"><i class="bi bi-trash"></i></button></div></div>'); //add input box
            });
            $(wrapper).on("click",".remove_field", function(e){ 
                e.preventDefault(); $(this).parent('div').parent('div').remove(); z--;
            });

    });

    $(document).ready(function () {
        var table = $('#table').DataTable({  
            ajax: {                
                url: 'ServiceLayer/GetItems.php',  
                dataSrc: "",
                data: {
                    "Groupe": "Consultation"
                }
            },
            "autoWidth": false,
            "bDestroy": true,
                columns: 
                [
                    { data: 'ItemCode' },
                    { data: 'ItemName' }
                ],
        });

        $('#table tbody').on('dblclick', 'tr', function () {
            
            var data = table.row(this).data();
            // $('#orm').val(data[1]); 
            console.log(data["ItemCode"]);
            $('#staticBackdrop_').modal('hide');
            $('body').removeClass('modal-open');
            $('.modal-backdrop_').remove();
            $('#staticBackdrop_').on('hidden.bs.modal', function() {
            $(this).removeData('bs.modal');
            $('#article_Consultation').val(data["ItemCode"]);
            $('#article_ConDescription').val(data["ItemName"]);
            });            
        });    
    });

    $(document).ready(function () {
        var table = $('#table1').DataTable({  
            ajax: {                
                url: 'ServiceLayer/GetItems.php',  
                dataSrc: "",
                data: {
                    "Groupe": "Médicament"
                }
            },
            "autoWidth": false,
            "bDestroy": true,
                columns: 
                [
                    { data: 'ItemCode' },
                    { data: 'ItemName' }
                ],
        });

        $('#table1 tbody').on('dblclick', 'tr', function () {
            
            var data = table.row(this).data();
            // $('#orm').val(data[1]); 
            console.log(data["ItemCode"]);
            $('#staticBackdrop').modal('hide');
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
            $('#staticBackdrop').on('hidden.bs.modal', function() {
            $(this).removeData('bs.modal');
            $('#article_'+item).val(data["ItemCode"]);
            $('#Description_'+item).val(data["ItemName"]);
            });            
        });    
    });

    $(document).ready(function () {
        var table = $('#table2').DataTable({  
            ajax: {                
                url: 'ServiceLayer/GetItems.php',  
                dataSrc: "",
                data: {
                    "Groupe": "Radio"
                }
            },
            "autoWidth": false,
            "bDestroy": true,
                columns: 
                [
                    { data: 'ItemCode' },
                    { data: 'ItemName' }
                ],
        });

        $('#table2 tbody').on('dblclick', 'tr', function () {
            
            var data = table.row(this).data();
        // $('#ra').val(data[1]); 
            $('#staticBackdrop1').modal('hide');
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
            $('#staticBackdrop1').on('hidden.bs.modal', function() {
                $(this).removeData('bs.modal');
                $('#radio_'+item1).val(data["ItemCode"]);
                $('#RadioDescription_'+item1).val(data["ItemName"]);
                
            });            
        });    
    });


    $(document).ready(function () {

        $("#Dashboard").removeClass("active");
        $("#Consultation").addClass("active");

        var table = $('#table3').DataTable({  
            ajax: {                
                url: 'ServiceLayer/GetItems.php',  
                dataSrc: "",
                data: {
                    "Groupe": "Analyse"
                }
            },
            "autoWidth": false,
            "bDestroy": true,
                columns: 
                [
                    { data: 'ItemCode' },
                    { data: 'ItemName' }
                ],
        });

        $('#table3 tbody').on('dblclick', 'tr', function () {
            
            var data = table.row(this).data();
            //$('#an').val(data[1]); 
            $('#staticBackdrop2').modal('hide');
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
            $('#staticBackdrop2').on('hidden.bs.modal', function() {
                $(this).removeData('bs.modal');
                $('#analyse_'+item2).val(data["ItemCode"]);
                $('#AnalyseDescription_'+item2).val(data["ItemName"]);
            });            
        });

        const queryString = window.location.search;
        const DocEntry = new URLSearchParams(queryString).get('DocEntry')
 
        //Get Consultations
        $.ajax({    
            type: "GET",
            data: { "DocEntry": DocEntry, },
            url: "ServiceLayer/GetConsultation.php",             
            dataType: "html",                  
            success: function(data){

                var data = JSON.parse(data);                    
                //console.log(data);

                $('#DocEntry').val(data[0]["DocEntry"]);
                $('#PCode').val(data[0]["CodePatient"]);
                $('#PName').val(data[0]["NomPatient"]);
                $('#ConsDate').val(data[0]["U_DateConsultation"]);
                $('#Note').val(data[0]["U_Notes"]);
                $('#Type').val(data[0]["U_ActivityType"]);
                $('#Poids').val(data[0]["U_Poids"]);
                $('#PA').val(data[0]["U_PA"]);
                $('#Statut').val(data[0]["U_Statut"]);            
            }
        });

        //Get Consultations Lines
        $.ajax({
            type: "GET",
            data: { "DocEntry": DocEntry, },
            url: "ServiceLayer/GetConsultationLines.php",             
            dataType: "html",
            success: function(data) {

                var data = JSON.parse(data);                
                console.log(data[0]);
                console.log(data[1]);
                console.log(data[2]);
                console.log(data[3]);

                if (typeof data[0][0] != "undefined") {
                    $("#article_Consultation").val(data[0][0]["U_Consultation"]);
                    $("#article_ConDescription").val(data[0][0]["U_Description"]);
                    $("#Notes").val(data[0][0]["U_Notes"]);
                }
                
                if (typeof data[1] != "undefined") {
                    var Ordonnance = data[1];
                    $.each(Ordonnance, function(i) {
                        $(".add_field_button").trigger("click");
                        $("#article_"+i).val(Ordonnance[i]["U_ItemCode"]);
                        $("#Description_"+i).val(Ordonnance[i]["U_Description"]);
                        $("#articleQte_"+i).val(Ordonnance[i]["U_Qte"]);
                        $("#articleInstruction_"+i).val(Ordonnance[i]["U_Instructions"]);
                    });
                }

                if (typeof data[2] != "undefined") {
                    var Radio = data[2];
                    $.each(Radio, function(i) {
                        $(".add_field_button2").trigger("click");
                        $("#radio_"+i).val(Radio[i]["U_ItemCode"]);
                        $("#RadioDescription_"+i).val(Radio[i]["U_Description"]);
                        $("#RadioInstruction_"+i).val(Radio[i]["U_Instructions"]);
                    });
                }

                if (typeof data[3] != "undefined") {
                    var Analyse = data[3];
                    $.each(Analyse, function(i) {
                        console.log("Click triggered "+i);
                        $(".add_field_button3").trigger("click");
                        $("#analyse_"+i).val(Analyse[i]["U_ItemCode"]);
                        $("#AnalyseDescription_"+i).val(Analyse[i]["U_Description"]);
                        $("#AnalyseInstruction_"+i).val(Analyse[i]["U_Instructions"]);
                    });
                }

            }
        });
    
    });

    function add1(raa){
        item1 =  $(raa).attr('id');
    }

    function add2(anal){
        item2 =  $(anal).attr('id');
    }
    
    function add(or){
        item =  $(or).attr('id');
    } 

</script>

</body>

</html>